Define CONF_WORD = 0x3f50

'program to control for 8 Turnouts with single coil or motor drive.
'By Peter Giling

'board MGV125
'due to low power supply, only one output will be activated at all times.
'positions are saves in EEprom to allow postion memory.

Dim turnout_1 As Bit
Dim turnout_2 As Bit
Dim turnout_3 As Bit
Dim turnout_4 As Bit
Dim turnout_5 As Bit
Dim turnout_6 As Bit
Dim turnout_7 As Bit
Dim turnout_8 As Bit
Dim dip_switch As Byte
Dim turnout_delay As Word
Dim position As Byte

AllDigital
TRISA = %11111111
TRISB = %11111111
Symbol dta = PORTB.0
Symbol sck = PORTB.1
I2CPrepare dta, sck
WaitMs 100
Call turnout_command(64, 0)
Call turnout_command(66, 0)
WaitMs 5000          'give 5 seconds to get all units ready
dip_switch = PORTA
dip_switch = dip_switch And %00011100

Select Case dip_switch
Case 0
	turnout_delay = 100
Case 4
	turnout_delay = 200
Case 8
	turnout_delay = 400
Case 12
	turnout_delay = 800
Case 16
	turnout_delay = 1600
Case 20
	turnout_delay = 3200
Case 24
	turnout_delay = 6400
Case Else
	turnout_delay = 12800
EndSelect
Read 1, position
turnout_1 = position.0
Read 2, position
turnout_2 = position.0
Read 3, position
turnout_3 = position.0
Read 4, position
turnout_4 = position.0
Read 5, position
turnout_5 = position.0
Read 6, position
turnout_6 = position.0
Read 7, position
turnout_7 = position.0
Read 8, position
turnout_8 = position.0
main:
		If RA0 <> turnout_1 Then          'turnout 1 to be checked
			If turnout_1 = 1 Then
				Call turnout_command(64, %00000001)
				WaitMs turnout_delay
				Call turnout_command(64, 0)
				turnout_1 = 0
				position = 0
			Else
				Call turnout_command(64, %00000010)
				WaitMs turnout_delay
				Call turnout_command(64, 0)
				turnout_1 = 1
				position = 1
			Endif
			Write 1, position          'store actial position
		Endif
		If RA1 <> turnout_2 Then          'turnout  2 to be checked
			If turnout_2 = 1 Then
				Call turnout_command(64, %00000100)
				WaitMs turnout_delay
				Call turnout_command(64, 0)
				turnout_2 = 0
				position = 0
			Else
				Call turnout_command(64, %00001000)
				WaitMs turnout_delay
				Call turnout_command(64, 0)
				turnout_2 = 1
				position = 1
			Endif
			Write 2, position          'store actial position
		Endif
		If RB5 <> turnout_3 Then          'turnout  3 to be checked
			If turnout_3 = 1 Then
				Call turnout_command(64, %00010000)
				WaitMs turnout_delay
				Call turnout_command(64, 0)
				turnout_3 = 0
				position = 0
			Else
				Call turnout_command(64, %00100000)
				WaitMs turnout_delay
				Call turnout_command(64, 0)
				turnout_3 = 1
				position = 1
			Endif
			Write 3, position          'store actial position
		Endif
		If RA5 <> turnout_4 Then          'turnout  4 to be checked
			If turnout_4 = 1 Then
				Call turnout_command(64, %01000000)
				WaitMs turnout_delay
				Call turnout_command(64, 0)
				turnout_4 = 0
				position = 0
			Else
				Call turnout_command(64, %10000000)
				WaitMs turnout_delay
				Call turnout_command(64, 0)
				turnout_4 = 1
				position = 1
			Endif
			Write 4, position          'store actial position
		Endif
		If RB7 <> turnout_5 Then          'turnout 5 to be checked
			If turnout_5 = 1 Then
				Call turnout_command(66, %00000001)
				WaitMs turnout_delay
				Call turnout_command(66, 0)
				turnout_5 = 0
				position = 0
			Else
				Call turnout_command(66, %00000010)
				WaitMs turnout_delay
				Call turnout_command(66, 0)
				turnout_5 = 1
				position = 1
			Endif
			Write 5, position          'store actial position
		Endif
		If RB6 <> turnout_6 Then          'turnout  6 to be checked
			If turnout_6 = 1 Then
				Call turnout_command(66, %00000100)
				WaitMs turnout_delay
				Call turnout_command(66, 0)
				turnout_6 = 0
				position = 0
			Else
				Call turnout_command(66, %00001000)
				WaitMs turnout_delay
				Call turnout_command(66, 0)
				turnout_6 = 1
				position = 1
			Endif
			Write 6, position          'store actial position
		Endif
		If RA6 <> turnout_7 Then          'turnout  7 to be checked
			If turnout_7 = 1 Then
				Call turnout_command(66, %00010000)
				WaitMs turnout_delay
				Call turnout_command(66, 0)
				turnout_7 = 0
				position = 0
			Else
				Call turnout_command(66, %00100000)
				WaitMs turnout_delay
				Call turnout_command(66, 0)
				turnout_7 = 1
				position = 1
			Endif
			Write 7, position          'store actial position
		Endif
		If RA7 <> turnout_8 Then          'turnout  8 to be checked
			If turnout_8 = 1 Then
				Call turnout_command(66, %01000000)
				WaitMs turnout_delay
				Call turnout_command(66, 0)
				turnout_8 = 0
				position = 0
			Else
				Call turnout_command(66, %10000000)
				WaitMs turnout_delay
				Call turnout_command(66, 0)
				turnout_8 = 1
				position = 1
			Endif
			Write 8, position          'store actial position
		Endif
		WaitMs 1

End                                               
Proc turnout_command(address As Byte, val As Byte)
	I2CStart
	I2CSend address
	I2CSend val
	I2CStop
End Proc                                          
