; Compiled with: PIC Simulator IDE v6.86
; Microcontroller model: PIC12F675
; Clock frequency: 4.0 MHz
;
;       The address of 'short_count1' (byte) (global) is 0x2D
	short_count1 EQU 0x2D
;       The address of 'short_count2' (byte) (global) is 0x2E
	short_count2 EQU 0x2E
;       The address of 'short_time' (byte) (global) is 0x2F
	short_time EQU 0x2F
;       The address of 'pulse_count1' (byte) (global) is 0x30
	pulse_count1 EQU 0x30
;       The address of 'pulse_count2' (byte) (global) is 0x31
	pulse_count2 EQU 0x31
;       The address of 'v_r5' (word) (global) is 0x32
	v_r5 EQU 0x32
;       The address of 'previous_pulse1' (bit) (global) is 0x2C,0
;       The address of 'previous_pulse2' (bit) (global) is 0x2C,1
;       The address of 'max_current' (word) (global) is 0x34
	max_current EQU 0x34
;       The address of 'ok_state' (byte) (global) is 0x36
	ok_state EQU 0x36
;       The address of 'pulse1' (bit) (global) is 0x5,2
;       The address of 'pulse2' (bit) (global) is 0x5,3
;       The address of 'l6203_enable' (bit) (global) is 0x5,4
;       The address of 'booster_on' (bit) (global) is 0x5,5
; Begin
	R0L EQU 0x20
	R0H EQU 0x21
	R1L EQU 0x22
	R1H EQU 0x23
	R2L EQU 0x24
	R2H EQU 0x25
	R3L EQU 0x26
	R3H EQU 0x27
	R4L EQU 0x28
	R4H EQU 0x29
	R5L EQU 0x2A
	R5H EQU 0x2B
	ORG 0x0000
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0003
	ORG 0x0004
	RETFIE
; Begin of program
L0003:
; 1: 
; 2: 'program for ORD-3 Spax booster / DDX Booster
; 3: 
; 4: Define CONF_WORD = 0x3184
; 5: TRISIO = %001111
	BSF STATUS,RP0
	MOVLW 0x0F
	MOVWF 0x05
; 6: ANSEL = 1
	MOVLW 0x01
	MOVWF 0x1F
; 7: WPU = %000010 'internal pull-up's
	MOVLW 0x02
	MOVWF 0x15
	BCF STATUS,RP0
; 8: Dim short_count1 As Byte
; 9: Dim short_count2 As Byte
; 10: Dim short_time As Byte
; 11: Dim pulse_count1 As Byte
; 12: Dim pulse_count2 As Byte
; 13: Dim v_r5 As Word
; 14: Dim previous_pulse1 As Bit
; 15: Dim previous_pulse2 As Bit
; 16: Dim max_current As Word
; 17: 
; 18: Dim ok_state As Byte
; 19: Symbol pulse1 = GP2
; 20: Symbol pulse2 = GP3
; 21: Symbol l6203_enable = GP4
; 22: Symbol booster_on = GP5
; 23: l6203_enable = 0 'system off
	BCF 0x05,4
; 24: short_count1 = 0
	CLRF 0x2D
; 25: short_count2 = 0
	CLRF 0x2E
; 26: short_time = 0
	CLRF 0x2F
; 27: pulse_count1 = 0
	CLRF 0x30
; 28: pulse_count2 = 0
	CLRF 0x31
; 29: booster_on = 1
	BSF 0x05,5
; 30: ok_state = 0
	CLRF 0x36
; 31: WaitMs 2000
	MOVLW 0xD0
	MOVWF R0L
	MOVLW 0x07
	MOVWF R0H
	CALL W001
; 32: If GP1 = 1 Then
	BTFSS 0x05,1
	GOTO L0004
; 33: 	max_current = 202 '(V_r5 * 1023)/Vref  = 0,33Ohm x 3 Amp x 1023 / 5
	MOVLW 0xCA
	MOVWF 0x34
	CLRF 0x35
; 34: Else
	GOTO L0005
L0004:
; 35: 	max_current = 68 '(V_r5 * 1023)/Vref  = 0,33Ohm x 1 Amp x 1023 / 5
	MOVLW 0x44
	MOVWF 0x34
	CLRF 0x35
; 36: Endif
L0005:
; 37: main:
L0001:
; 38: 		WaitUs 750 'Total loop time of program = ~~ 250us.
	MOVLW 0xEE
	MOVWF R4L
	MOVLW 0x02
	MOVWF R4H
	CALL Y001
; 39: 					'.         so this will make  1 mS  for each loop
; 40: 		Gosub check_l6203
	CALL L0002
; 41: 		If ok_state.2 = 1 Then
	BTFSS 0x36,2
	GOTO L0006
; 42: 			If short_count2 > 0 Then
	MOVF 0x2E,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0007
; 43: 				If short_count1 > 0 Then
	MOVF 0x2D,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0008
; 44: 					short_count1 = short_count1 - 1
	MOVLW 0x01
	SUBWF 0x2D,W
	MOVWF 0x2D
; 45: 				Else
	GOTO L0009
L0008:
; 46: 					short_count2 = short_count2 - 1
	MOVLW 0x01
	SUBWF 0x2E,W
	MOVWF 0x2E
; 47: 					short_count1 = 200
	MOVLW 0xC8
	MOVWF 0x2D
; 48: 				Endif
L0009:
; 49: 			Else
	GOTO L0010
L0007:
; 50: 				ok_state.2 = 0
	BCF 0x36,2
; 51: 			Endif
L0010:
; 52: 		Endif
L0006:
; 53: 
; 54: 		If pulse1 <> previous_pulse1 Then 'check railsync
	CLRW
	BTFSC 0x05,2
	ADDLW 0x01
	BTFSC 0x2C,0
	SUBLW 0x01
	BTFSC STATUS,Z
	GOTO L0011
; 55: 			previous_pulse1 = pulse1 'remember this bit
	BTFSC 0x05,2
	BSF 0x2C,0
	BTFSS 0x05,2
	BCF 0x2C,0
; 56: 			ok_state.0 = 0
	BCF 0x36,0
; 57: 			pulse_count1 = 0
	CLRF 0x30
; 58: 		Else
	GOTO L0012
L0011:
; 59: 			If pulse_count1 < 30 Then 'within 30 mSec power off
	MOVLW 0x1E
	SUBWF 0x30,W
	BTFSC STATUS,C
	GOTO L0013
; 60: 				pulse_count1 = pulse_count1 + 1
	MOVF 0x30,W
	ADDLW 0x01
	MOVWF 0x30
; 61: 			Else
	GOTO L0014
L0013:
; 62: 				ok_state.0 = 1
	BSF 0x36,0
; 63: 			Endif
L0014:
; 64: 		Endif
L0012:
; 65: 		If pulse2 <> previous_pulse2 Then 'check railsync
	CLRW
	BTFSC 0x05,3
	ADDLW 0x01
	BTFSC 0x2C,1
	SUBLW 0x01
	BTFSC STATUS,Z
	GOTO L0015
; 66: 			previous_pulse2 = pulse2 'remember this bit
	BTFSC 0x05,3
	BSF 0x2C,1
	BTFSS 0x05,3
	BCF 0x2C,1
; 67: 			pulse_count2 = 0
	CLRF 0x31
; 68: 			ok_state.1 = 0
	BCF 0x36,1
; 69: 		Else
	GOTO L0016
L0015:
; 70: 			If pulse_count2 < 30 Then 'within 30 mSec power off
	MOVLW 0x1E
	SUBWF 0x31,W
	BTFSC STATUS,C
	GOTO L0017
; 71: 				pulse_count2 = pulse_count2 + 1
	MOVF 0x31,W
	ADDLW 0x01
	MOVWF 0x31
; 72: 			Else
	GOTO L0018
L0017:
; 73: 				ok_state.1 = 1
	BSF 0x36,1
; 74: 			Endif
L0018:
; 75: 		Endif
L0016:
; 76: 		Select Case ok_state
; 77: 		Case 0 'no problem found
	MOVF 0x36,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0019
; 78: 			l6203_enable = 1 'power on booster
	BSF 0x05,4
; 79: 			booster_on = 0
	BCF 0x05,5
; 80: 		Case Else 'no pulse found
	GOTO L0020
L0019:
; 81: 			l6203_enable = 0 'power off booster
	BCF 0x05,4
; 82: 			booster_on = 1
	BSF 0x05,5
; 83: 		EndSelect
L0020:
; 84: Goto main
	GOTO L0001
; 85: End
L0021:	GOTO L0021
; 86: 
; 87: check_l6203:
L0002:
; 88: 	Adcin 0, v_r5 'measure currect
	BSF ADCON0,ADFM
	BSF STATUS,RP0
	MOVLW 0x30
	IORWF ANSEL,F
	MOVLW 0x00
	BCF STATUS,RP0
	MOVWF R0L
	CALL A001
	BSF STATUS,RP0
	MOVF ADRESL,W
	BCF STATUS,RP0
	MOVWF 0x32
	MOVF ADRESH,W
	MOVWF 0x33
; 89: 	If v_r5 > max_current Then
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
	MOVF 0x35,W
	MOVWF R1H
	MOVF 0x34,W
	CALL C003
	BTFSS STATUS,Z
	GOTO L0022
; 90: 		If short_count1 < 200 Then '5 times too high = after 0,5 second
	MOVLW 0xC8
	SUBWF 0x2D,W
	BTFSC STATUS,C
	GOTO L0023
; 91: 			short_count1 = short_count1 + 1
	MOVF 0x2D,W
	ADDLW 0x01
	MOVWF 0x2D
; 92: 		Else
	GOTO L0024
L0023:
; 93: 			short_count2 = 25
	MOVLW 0x19
	MOVWF 0x2E
; 94: 			ok_state.2 = 1 'indicate power should be off
	BSF 0x36,2
; 95: 		Endif
L0024:
; 96: 	Endif
L0022:
; 97: Return
	RETURN
; 98: 
; 99: 
; End of program
L0025:	GOTO L0025
; Comparison Routine
C001:	MOVWF R1L
	MOVLW 0x05
	GOTO C007
C002:	MOVWF R1L
	MOVLW 0x02
	GOTO C007
C003:	MOVWF R1L
	MOVLW 0x06
	GOTO C007
C004:	MOVWF R1L
	MOVLW 0x03
	GOTO C007
C005:	MOVWF R1L
	MOVLW 0x04
	GOTO C007
C006:	MOVWF R1L
	MOVLW 0x01
	GOTO C007
C007:	MOVWF R4L
	MOVF R1H,W
	SUBWF R0H,W
	BTFSS STATUS,Z
	GOTO C008
	MOVF R1L,W
	SUBWF R0L,W
C008:	MOVLW 0x04
	BTFSC STATUS,C
	MOVLW 0x01
	BTFSC STATUS,Z
	MOVLW 0x02
	ANDWF R4L,W
	BTFSS STATUS,Z
	MOVLW 0xFF
	RETURN
; Waitms Routine
W001:	MOVF R0L,F
	BTFSC STATUS,Z
	GOTO W002
	CALL W003
	DECF R0L,F
	NOP
	NOP
	NOP
	NOP
	NOP
	GOTO W001
W002:	MOVF R0H,F
	BTFSC STATUS,Z
	RETURN
	CALL W003
	DECF R0H,F
	DECF R0L,F
	GOTO W001
W003:	MOVLW 0x0C
	MOVWF R2H
W004:	DECFSZ R2H,F
	GOTO W004
	NOP
	NOP
	MOVLW 0x12
	MOVWF R1L
W005:	DECFSZ R1L,F
	GOTO W006
	CALL W007
	CALL W007
	NOP
	NOP
	RETURN
W006:	CALL W007
	GOTO W005
W007:	MOVLW 0x0D
	MOVWF R2L
W008:	DECFSZ R2L,F
	GOTO W008
	NOP
	RETURN
; Waitus Routine - Byte Argument
X001:	MOVLW 0x0A
	SUBWF R4L,F
	BTFSS STATUS,C
	RETURN
	GOTO X002
X002:	MOVLW 0x06
	SUBWF R4L,F
	BTFSS STATUS,C
	RETURN
	GOTO X002
; Waitus Routine - Word Argument
Y001:	MOVLW 0x10
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
Y002:	MOVLW 0x0A
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
; Adcin Routine
A001:	RLF R0L,F
	RLF R0L,F
	MOVLW 0x3C
	ANDWF R0L,F
	MOVLW 0xC0
	ANDWF ADCON0,F
	MOVF R0L,W
	IORWF ADCON0,F
	BSF ADCON0,ADON
	MOVLW 0x14
	MOVWF R4L
	CALL X001
	BSF ADCON0,GO
A002:	BTFSC ADCON0,GO
	GOTO A002
	BCF PIR1,ADIF
	BCF ADCON0,ADON
	RETURN
; Configuration word settings
	ORG 0x2007
	DW 0x3184
; End of listing
	END
