; Compiled with: PIC Simulator IDE v7.61
; Microcontroller model: PIC16F628A
; Clock frequency: 4.0MHz
;
;       The value of 'maxcount1' (global) is 100
;       The value of 'maxcount2' (global) is 99
;       The address of 'mask' (byte) (global) is 0x020
;       The address of 'mask0' (byte) (global) is 0x021
;       The address of 'mask1' (byte) (global) is 0x022
;       The address of 'mask2' (byte) (global) is 0x023
;       The address of 'mask3' (byte) (global) is 0x024
;       The address of 'mask4' (byte) (global) is 0x025
;       The address of 'mask5' (byte) (global) is 0x026
;       The address of 'mask6' (byte) (global) is 0x027
;       The address of 'mask7' (byte) (global) is 0x028
;       The address of 'i0' (bit) (global) is 0x005,6
;       The address of 'i1' (bit) (global) is 0x005,5
;       The address of 'i2' (bit) (global) is 0x005,7
;       The address of 'i3' (bit) (global) is 0x005,4
;       The address of 'i4' (bit) (global) is 0x005,0
;       The address of 'i5' (bit) (global) is 0x005,3
;       The address of 'i6' (bit) (global) is 0x005,1
;       The address of 'i7' (bit) (global) is 0x005,2
;       The address of 'outo' (bit) (global) is 0x006,4
;       The address of 'out1' (bit) (global) is 0x006,5
;       The address of 'out2' (bit) (global) is 0x006,6
;       The address of 'out3' (bit) (global) is 0x006,7
;       The address of 'out4' (bit) (global) is 0x006,3
;       The address of 'out5' (bit) (global) is 0x006,2
;       The address of 'out6' (bit) (global) is 0x006,1
;       The address of 'out7' (bit) (global) is 0x006,0
	ORG 0x0000
	BCF PCLATH,4
	BCF PCLATH,3
	GOTO L0002
	ORG 0x0004
	RETFIE
; User code start
L0002:
; 1: 
; 2: 'program GCA86
; 3: 'fading sign decoder.
; 4: 'value of resistors R1 - R8 can be selected according desire.(usual 470 Ohm will satisfy)
; 5: 'logic state of each output will go eqial to input after dimming time.
; 6: 'with this option, common anode or common cathode are optional, but will reverse the input logic.
; 7: 
; 8: Define CONF_WORD = 0x3f50
; 9: 
; 10: Dim mask As Byte
; 11: Dim mask0 As Byte
; 12: Dim mask1 As Byte
; 13: Dim mask2 As Byte
; 14: Dim mask3 As Byte
; 15: Dim mask4 As Byte
; 16: Dim mask5 As Byte
; 17: Dim mask6 As Byte
; 18: Dim mask7 As Byte
; 19: Symbol i0 = RA6
; 20: Symbol i1 = RA5
; 21: Symbol i2 = RA7
; 22: Symbol i3 = RA4
; 23: Symbol i4 = RA0
; 24: Symbol i5 = RA3
; 25: Symbol i6 = RA1
; 26: Symbol i7 = RA2
; 27: Symbol outo = RB4
; 28: Symbol out1 = RB5
; 29: Symbol out2 = RB6
; 30: Symbol out3 = RB7
; 31: Symbol out4 = RB3
; 32: Symbol out5 = RB2
; 33: Symbol out6 = RB1
; 34: Symbol out7 = RB0
; 35: Const maxcount1 = 100
; 36: Const maxcount2 = 99
; 37: CMCON = 7
	MOVLW 0x07
	MOVWF CMCON
; 38: TRISA = 255
	MOVLW 0xFF
	BSF STATUS,RP0
	MOVWF TRISA
; 39: TRISB = 0
	CLRF TRISB
	BCF STATUS,RP0
; 40: PORTB = 0
	CLRF PORTB
; 41: 
; 42: main:
L0001:
; 43: If i0 = 0 Then
	BTFSC 0x005,6
	GOTO L0003
; 44: If mask0 > 0 Then
	MOVF 0x021,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0004
; 45: mask0 = mask0 - 1
	DECF 0x021,F
; 46: Endif
L0004:
; 47: Else
	GOTO L0005
L0003:
; 48: If mask0 < maxcount1 Then
	MOVLW 0x64
	SUBWF 0x021,W
	BTFSC STATUS,C
	GOTO L0006
; 49: mask0 = mask0 + 1
	INCF 0x021,F
; 50: Endif
L0006:
; 51: Endif
L0005:
; 52: If i1 = 0 Then
	BTFSC 0x005,5
	GOTO L0007
; 53: If mask1 > 0 Then
	MOVF 0x022,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0008
; 54: mask1 = mask1 - 1
	DECF 0x022,F
; 55: Endif
L0008:
; 56: Else
	GOTO L0009
L0007:
; 57: If mask1 < maxcount1 Then
	MOVLW 0x64
	SUBWF 0x022,W
	BTFSC STATUS,C
	GOTO L0010
; 58: mask1 = mask1 + 1
	INCF 0x022,F
; 59: Endif
L0010:
; 60: Endif
L0009:
; 61: If i2 = 0 Then
	BTFSC 0x005,7
	GOTO L0011
; 62: If mask2 > 0 Then
	MOVF 0x023,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0012
; 63: mask2 = mask2 - 1
	DECF 0x023,F
; 64: Endif
L0012:
; 65: Else
	GOTO L0013
L0011:
; 66: If mask2 < maxcount1 Then
	MOVLW 0x64
	SUBWF 0x023,W
	BTFSC STATUS,C
	GOTO L0014
; 67: mask2 = mask2 + 1
	INCF 0x023,F
; 68: Endif
L0014:
; 69: Endif
L0013:
; 70: If i3 = 0 Then
	BTFSC 0x005,4
	GOTO L0015
; 71: If mask3 > 0 Then
	MOVF 0x024,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0016
; 72: mask3 = mask3 - 1
	DECF 0x024,F
; 73: Endif
L0016:
; 74: Else
	GOTO L0017
L0015:
; 75: If mask3 < maxcount1 Then
	MOVLW 0x64
	SUBWF 0x024,W
	BTFSC STATUS,C
	GOTO L0018
; 76: mask3 = mask3 + 1
	INCF 0x024,F
; 77: Endif
L0018:
; 78: Endif
L0017:
; 79: If i4 = 0 Then
	BTFSC 0x005,0
	GOTO L0019
; 80: If mask4 > 0 Then
	MOVF 0x025,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0020
; 81: mask4 = mask4 - 1
	DECF 0x025,F
; 82: Endif
L0020:
; 83: Else
	GOTO L0021
L0019:
; 84: If mask4 < maxcount1 Then
	MOVLW 0x64
	SUBWF 0x025,W
	BTFSC STATUS,C
	GOTO L0022
; 85: mask4 = mask4 + 1
	INCF 0x025,F
; 86: Endif
L0022:
; 87: Endif
L0021:
; 88: If i5 = 0 Then
	BTFSC 0x005,3
	GOTO L0023
; 89: If mask5 > 0 Then
	MOVF 0x026,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0024
; 90: mask5 = mask5 - 1
	DECF 0x026,F
; 91: Endif
L0024:
; 92: Else
	GOTO L0025
L0023:
; 93: If mask5 < maxcount1 Then
	MOVLW 0x64
	SUBWF 0x026,W
	BTFSC STATUS,C
	GOTO L0026
; 94: mask5 = mask5 + 1
	INCF 0x026,F
; 95: Endif
L0026:
; 96: Endif
L0025:
; 97: If i6 = 0 Then
	BTFSC 0x005,1
	GOTO L0027
; 98: If mask6 > 0 Then
	MOVF 0x027,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0028
; 99: mask6 = mask6 - 1
	DECF 0x027,F
; 100: Endif
L0028:
; 101: Else
	GOTO L0029
L0027:
; 102: If mask6 < maxcount1 Then
	MOVLW 0x64
	SUBWF 0x027,W
	BTFSC STATUS,C
	GOTO L0030
; 103: mask6 = mask6 + 1
	INCF 0x027,F
; 104: Endif
L0030:
; 105: Endif
L0029:
; 106: If i7 = 0 Then
	BTFSC 0x005,2
	GOTO L0031
; 107: If mask7 > 0 Then
	MOVF 0x028,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0032
; 108: mask7 = mask7 - 1
	DECF 0x028,F
; 109: Endif
L0032:
; 110: Else
	GOTO L0033
L0031:
; 111: If mask7 < maxcount1 Then
	MOVLW 0x64
	SUBWF 0x028,W
	BTFSC STATUS,C
	GOTO L0034
; 112: mask7 = mask7 + 1
	INCF 0x028,F
; 113: Endif
L0034:
; 114: Endif
L0033:
; 115: For mask = 0 To maxcount2  'generate complete duty cycle for each output, in 50 steps
	CLRF 0x020
L0035:
	MOVF 0x020,W
	SUBLW 0x63
	BTFSS STATUS,C
	GOTO L0036
; 116: If mask0 <= mask Then
	MOVF 0x021,W
	SUBWF 0x020,W
	BTFSS STATUS,C
	GOTO L0037
; 117: outo = 0
	BCF PORTB,4
; 118: Else
	GOTO L0038
L0037:
; 119: outo = 1
	BSF PORTB,4
; 120: Endif
L0038:
; 121: If mask1 <= mask Then
	MOVF 0x022,W
	SUBWF 0x020,W
	BTFSS STATUS,C
	GOTO L0039
; 122: out1 = 0
	BCF PORTB,5
; 123: Else
	GOTO L0040
L0039:
; 124: out1 = 1
	BSF PORTB,5
; 125: Endif
L0040:
; 126: If mask2 <= mask Then
	MOVF 0x023,W
	SUBWF 0x020,W
	BTFSS STATUS,C
	GOTO L0041
; 127: out2 = 0
	BCF PORTB,6
; 128: Else
	GOTO L0042
L0041:
; 129: out2 = 1
	BSF PORTB,6
; 130: Endif
L0042:
; 131: If mask3 <= mask Then
	MOVF 0x024,W
	SUBWF 0x020,W
	BTFSS STATUS,C
	GOTO L0043
; 132: out3 = 0
	BCF PORTB,7
; 133: Else
	GOTO L0044
L0043:
; 134: out3 = 1
	BSF PORTB,7
; 135: Endif
L0044:
; 136: If mask4 <= mask Then
	MOVF 0x025,W
	SUBWF 0x020,W
	BTFSS STATUS,C
	GOTO L0045
; 137: out4 = 0
	BCF PORTB,3
; 138: Else
	GOTO L0046
L0045:
; 139: out4 = 1
	BSF PORTB,3
; 140: Endif
L0046:
; 141: If mask5 <= mask Then
	MOVF 0x026,W
	SUBWF 0x020,W
	BTFSS STATUS,C
	GOTO L0047
; 142: out5 = 0
	BCF PORTB,2
; 143: Else
	GOTO L0048
L0047:
; 144: out5 = 1
	BSF PORTB,2
; 145: Endif
L0048:
; 146: If mask6 <= mask Then
	MOVF 0x027,W
	SUBWF 0x020,W
	BTFSS STATUS,C
	GOTO L0049
; 147: out6 = 0
	BCF PORTB,1
; 148: Else
	GOTO L0050
L0049:
; 149: out6 = 1
	BSF PORTB,1
; 150: Endif
L0050:
; 151: If mask7 <= mask Then
	MOVF 0x028,W
	SUBWF 0x020,W
	BTFSS STATUS,C
	GOTO L0051
; 152: out7 = 0
	BCF PORTB,0
; 153: Else
	GOTO L0052
L0051:
; 154: out7 = 1
	BSF PORTB,0
; 155: Endif
L0052:
; 156: Next mask
	MOVLW 0x01
	ADDWF 0x020,F
	BTFSS STATUS,C
	GOTO L0035
L0036:
; 157: 
; 158: Goto main
	GOTO L0001
; 159: End
L0053:	GOTO L0053
; Library code
; End of user code
L0054:	GOTO L0054
;
;
;
;
;
;
; Configuration settings
	ORG 0x2007
	DW 0x3F50
; End of listing
	END
