; Compiled with: PIC Simulator IDE v7.42
; Microcontroller model: PIC16F886
; Clock frequency: 20.0MHz
;
	R0L EQU 0x020
	R0H EQU 0x021
	R1L EQU 0x022
	R1H EQU 0x023
	R2L EQU 0x024
	R2H EQU 0x025
	R3L EQU 0x026
	R4L EQU 0x028
	R4H EQU 0x029
	R0HL EQU 0x020
	R1HL EQU 0x022
	R2HL EQU 0x024
	R4HL EQU 0x028
	R1HL0HL EQU 0x020
	LONG_0 EQU 0x02A
	LONG_1 EQU 0x02B
	LONG_2 EQU 0x02C
	LONG_3 EQU 0x02D
	LONG2_0 EQU 0x02E
	LONG2_1 EQU 0x02F
	LONG2_2 EQU 0x030
	LONG2_3 EQU 0x031
	LONG1 EQU 0x02A
	LONG2 EQU 0x02E
	AARGB5 EQU 0x032
	AARGB4 EQU 0x033
	AARGB3 EQU 0x034
	AARGB2 EQU 0x035
	AARGB1 EQU 0x036
	AARGB0 EQU 0x037
	AEXP EQU 0x038
	BARGB3 EQU 0x039
	BARGB2 EQU 0x03A
	BARGB1 EQU 0x03B
	BARGB0 EQU 0x03C
	BEXP EQU 0x03D
	TEMPB1 EQU 0x03E
	TEMPB0 EQU 0x03F
	SIGN EQU 0x040
	FPFLAGS EQU 0x041
	SCL_PORT EQU 0x027
	SCL_BIT EQU 0x04B
	SDA_PORT EQU 0x04C
	SDA_BIT EQU 0x04D
;       The address of 'dip_switch' (byte) (global) is 0x051
;       The address of 'turnout_delay' (word) (global) is 0x056
;       The address of 'calc_delay' (single) (global) is 0x052
;       The address of 'positions' (byte) (global) is 0x04E
;       The address of 'adress' (byte) (ctrl_motor) is 0x04F
;       The address of 'value' (byte) (ctrl_motor) is 0x050
;       The address of 'dta' (bit) (global) is 0x006,0
;       The address of 'sck' (bit) (global) is 0x006,1
;       The address of 'green' (bit) (global) is 0x006,2
;       The address of 'red' (bit) (global) is 0x006,3
	ORG 0x0000
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0004
	ORG 0x0004
	RETFIE
; User code start
L0004:
	CLRF 0x041
; 1: Define CONF_WORD = 0x3f50
; 2: 
; 3: 
; 4: 
; 5: 'program to control for 8 Turnouts with single coil or motor drive.
; 6: 'By Peter Giling
; 7: 
; 8: 'board MGV125
; 9: 'due to low power supply, only one output will be activated at all times.
; 10: 'positions are saved in EEprom to allow correct startup.
; 11: Define SIMULATION_WAITMS_VALUE = 0
; 12: Dim dip_switch As Byte
; 13: Dim turnout_delay As Word
; 14: Dim calc_delay As Single
; 15: Dim positions As Byte
; 16: AllDigital
	BSF STATUS,RP0
	BSF STATUS,RP1
	CLRF ANSEL
	CLRF ANSELH
	BCF STATUS,RP1
	BCF STATUS,RP0
; 17: TRISA = %11111111
	MOVLW 0xFF
	BSF STATUS,RP0
	MOVWF TRISA
	BCF STATUS,RP0
; 18: TRISB = %11110011
	MOVLW 0xF3
	BSF STATUS,RP0
	MOVWF TRISB
	BCF STATUS,RP0
; 19: Symbol dta = RB0
; 20: Symbol sck = RB1
; 21: Symbol green = RB2
; 22: Symbol red = RB3
; 23: I2CPrepare dta, sck
	BCF STATUS,IRP
	MOVLW 0x06
	MOVWF SDA_PORT
	MOVLW 0x01
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISB,0
	BCF STATUS,RP0
	MOVLW 0x06
	MOVWF SCL_PORT
	MOVLW 0x02
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISB,1
	BCF STATUS,RP0
	CALL IC41
	CALL IC41
; 24: WaitMs 100
; 25: Call ctrl_motor(64, 0)  'set motors 1..4 off
	MOVLW 0x40
	MOVWF 0x04F
	CLRF 0x050
	CALL L0002
; 26: Call ctrl_motor(66, 0)  'set motors 5..8 off
	MOVLW 0x42
	MOVWF 0x04F
	CLRF 0x050
	CALL L0002
; 27: WaitMs 1000  'give time to get all units ready
; 28: Read 1, positions
	MOVLW 0x01
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x04E
; 29: green = 1  'green led on
	BSF PORTB,2
; 30: red = 0  'red led off
	BCF PORTB,3
; 31: main:
L0001:
; 32: Gosub get_turnout_delay
	CALL L0003
; 33: If RA1 <> positions.0 Then  'turnout 1 to be checked
	CLRW
	BTFSC 0x005,1
	ADDLW 0x01
	BTFSC 0x04E,0
	SUBLW 0x01
	BTFSC STATUS,Z
	GOTO L0005
; 34: If positions.0 = 1 Then
	BTFSS 0x04E,0
	GOTO L0006
; 35: Call ctrl_motor(64, %00000001)
	MOVLW 0x40
	MOVWF 0x04F
	MOVLW 0x01
	MOVWF 0x050
	CALL L0002
; 36: positions.0 = 0
	BCF 0x04E,0
; 37: Else
	GOTO L0007
L0006:
; 38: Call ctrl_motor(64, %00000010)
	MOVLW 0x40
	MOVWF 0x04F
	MOVLW 0x02
	MOVWF 0x050
	CALL L0002
; 39: positions.0 = 1
	BSF 0x04E,0
; 40: Endif
L0007:
; 41: Write 1, positions  'store actial position
	MOVLW 0x01
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x04E,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0008:	BTFSC EECON1,WR
	GOTO L0008
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 42: Endif
L0005:
; 43: 
; 44: If RA0 <> positions.1 Then  'turnout  2 to be checked
	CLRW
	BTFSC 0x005,0
	ADDLW 0x01
	BTFSC 0x04E,1
	SUBLW 0x01
	BTFSC STATUS,Z
	GOTO L0009
; 45: If positions.1 = 1 Then
	BTFSS 0x04E,1
	GOTO L0010
; 46: Call ctrl_motor(64, %00000100)
	MOVLW 0x40
	MOVWF 0x04F
	MOVLW 0x04
	MOVWF 0x050
	CALL L0002
; 47: positions.1 = 0
	BCF 0x04E,1
; 48: Else
	GOTO L0011
L0010:
; 49: Call ctrl_motor(64, %00001000)
	MOVLW 0x40
	MOVWF 0x04F
	MOVLW 0x08
	MOVWF 0x050
	CALL L0002
; 50: positions.1 = 1
	BSF 0x04E,1
; 51: Endif
L0011:
; 52: Write 1, positions  'store actial position
	MOVLW 0x01
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x04E,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0012:	BTFSC EECON1,WR
	GOTO L0012
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 53: Endif
L0009:
; 54: 
; 55: If RA7 <> positions.2 Then  'turnout  3 to be checked
	CLRW
	BTFSC 0x005,7
	ADDLW 0x01
	BTFSC 0x04E,2
	SUBLW 0x01
	BTFSC STATUS,Z
	GOTO L0013
; 56: If positions.2 = 1 Then
	BTFSS 0x04E,2
	GOTO L0014
; 57: Call ctrl_motor(64, %00010000)
	MOVLW 0x40
	MOVWF 0x04F
	MOVLW 0x10
	MOVWF 0x050
	CALL L0002
; 58: positions.2 = 0
	BCF 0x04E,2
; 59: Else
	GOTO L0015
L0014:
; 60: Call ctrl_motor(64, %00100000)
	MOVLW 0x40
	MOVWF 0x04F
	MOVLW 0x20
	MOVWF 0x050
	CALL L0002
; 61: positions.2 = 1
	BSF 0x04E,2
; 62: Endif
L0015:
; 63: Write 1, positions  'store actial position
	MOVLW 0x01
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x04E,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0016:	BTFSC EECON1,WR
	GOTO L0016
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 64: Endif
L0013:
; 65: 
; 66: If RA6 <> positions.3 Then  'turnout  4 to be checked
	CLRW
	BTFSC 0x005,6
	ADDLW 0x01
	BTFSC 0x04E,3
	SUBLW 0x01
	BTFSC STATUS,Z
	GOTO L0017
; 67: If positions.3 = 1 Then
	BTFSS 0x04E,3
	GOTO L0018
; 68: Call ctrl_motor(64, %01000000)
	MOVLW 0x40
	MOVWF 0x04F
	MOVLW 0x40
	MOVWF 0x050
	CALL L0002
; 69: positions.3 = 0
	BCF 0x04E,3
; 70: Else
	GOTO L0019
L0018:
; 71: Call ctrl_motor(64, %10000000)
	MOVLW 0x40
	MOVWF 0x04F
	MOVLW 0x80
	MOVWF 0x050
	CALL L0002
; 72: positions.3 = 1
	BSF 0x04E,3
; 73: Endif
L0019:
; 74: Write 1, positions  'store actial position
	MOVLW 0x01
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x04E,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0020:	BTFSC EECON1,WR
	GOTO L0020
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 75: Endif
L0017:
; 76: 
; 77: If RB7 <> positions.4 Then  'turnout 5 to be checked
	CLRW
	BTFSC 0x006,7
	ADDLW 0x01
	BTFSC 0x04E,4
	SUBLW 0x01
	BTFSC STATUS,Z
	GOTO L0021
; 78: If positions.4 = 1 Then
	BTFSS 0x04E,4
	GOTO L0022
; 79: Call ctrl_motor(66, %00000001)
	MOVLW 0x42
	MOVWF 0x04F
	MOVLW 0x01
	MOVWF 0x050
	CALL L0002
; 80: positions.4 = 0
	BCF 0x04E,4
; 81: Else
	GOTO L0023
L0022:
; 82: Call ctrl_motor(66, %00000010)
	MOVLW 0x42
	MOVWF 0x04F
	MOVLW 0x02
	MOVWF 0x050
	CALL L0002
; 83: positions.4 = 1
	BSF 0x04E,4
; 84: Endif
L0023:
; 85: Write 1, positions  'store actial position
	MOVLW 0x01
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x04E,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0024:	BTFSC EECON1,WR
	GOTO L0024
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 86: Endif
L0021:
; 87: 
; 88: If RB6 <> positions.5 Then  'turnout 6 to be checked
	CLRW
	BTFSC 0x006,6
	ADDLW 0x01
	BTFSC 0x04E,5
	SUBLW 0x01
	BTFSC STATUS,Z
	GOTO L0025
; 89: If positions.5 = 1 Then
	BTFSS 0x04E,5
	GOTO L0026
; 90: Call ctrl_motor(66, %00000100)
	MOVLW 0x42
	MOVWF 0x04F
	MOVLW 0x04
	MOVWF 0x050
	CALL L0002
; 91: positions.5 = 0
	BCF 0x04E,5
; 92: Else
	GOTO L0027
L0026:
; 93: Call ctrl_motor(66, %00001000)
	MOVLW 0x42
	MOVWF 0x04F
	MOVLW 0x08
	MOVWF 0x050
	CALL L0002
; 94: positions.5 = 1
	BSF 0x04E,5
; 95: Endif
L0027:
; 96: Write 1, positions  'store actial position
	MOVLW 0x01
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x04E,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0028:	BTFSC EECON1,WR
	GOTO L0028
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 97: Endif
L0025:
; 98: 
; 99: If RB5 <> positions.6 Then  'turnout 7 to be checked
	CLRW
	BTFSC 0x006,5
	ADDLW 0x01
	BTFSC 0x04E,6
	SUBLW 0x01
	BTFSC STATUS,Z
	GOTO L0029
; 100: If positions.6 = 1 Then
	BTFSS 0x04E,6
	GOTO L0030
; 101: Call ctrl_motor(66, %00010000)
	MOVLW 0x42
	MOVWF 0x04F
	MOVLW 0x10
	MOVWF 0x050
	CALL L0002
; 102: positions.6 = 0
	BCF 0x04E,6
; 103: Else
	GOTO L0031
L0030:
; 104: Call ctrl_motor(66, %00100000)
	MOVLW 0x42
	MOVWF 0x04F
	MOVLW 0x20
	MOVWF 0x050
	CALL L0002
; 105: positions.6 = 1
	BSF 0x04E,6
; 106: Endif
L0031:
; 107: Write 1, positions  'store actial position
	MOVLW 0x01
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x04E,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0032:	BTFSC EECON1,WR
	GOTO L0032
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 108: Endif
L0029:
; 109: 
; 110: If RB4 <> positions.7 Then  'turnout 7 to be checked
	CLRW
	BTFSC 0x006,4
	ADDLW 0x01
	BTFSC 0x04E,7
	SUBLW 0x01
	BTFSC STATUS,Z
	GOTO L0033
; 111: If positions.7 = 1 Then
	BTFSS 0x04E,7
	GOTO L0034
; 112: Call ctrl_motor(66, %01000000)
	MOVLW 0x42
	MOVWF 0x04F
	MOVLW 0x40
	MOVWF 0x050
	CALL L0002
; 113: positions.7 = 0
	BCF 0x04E,7
; 114: Else
	GOTO L0035
L0034:
; 115: Call ctrl_motor(66, %10000000)
	MOVLW 0x42
	MOVWF 0x04F
	MOVLW 0x80
	MOVWF 0x050
	CALL L0002
; 116: positions.7 = 1
	BSF 0x04E,7
; 117: Endif
L0035:
; 118: Write 1, positions  'store actial position
	MOVLW 0x01
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x04E,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0036:	BTFSC EECON1,WR
	GOTO L0036
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 119: Endif
L0033:
; 120: 
; 121: WaitMs 100
; 122: Goto main
	GOTO L0001
; 123: End
L0037:	GOTO L0037
; 124: Proc ctrl_motor(adress As Byte, value As Byte)
L0002:
; 125: green = 0  'green led off
	BCF PORTB,2
; 126: red = 1  'red led on
	BSF PORTB,3
; 127: I2CStart  'actovate motor(x)
	CALL IC31
; 128: I2CSend adress
	MOVF 0x04F,W
	CALL IC01
; 129: I2CSend value
	MOVF 0x050,W
	CALL IC01
; 130: I2CStop
	CALL IC41
; 131: WaitMs turnout_delay
; 132: I2CStart  'now motor(x) off again
	CALL IC31
; 133: I2CSend adress
	MOVF 0x04F,W
	CALL IC01
; 134: I2CSend 0
	MOVLW 0x00
	CALL IC01
; 135: I2CStop
	CALL IC41
; 136: green = 1  'green led on
	BSF PORTB,2
; 137: red = 0  'red led off
	BCF PORTB,3
; 138: 
; 139: End Proc
	RETURN
; 140: 
; 141: get_turnout_delay:
L0003:
; 142: dip_switch = PORTA
	MOVF PORTA,W
	MOVWF 0x051
; 143: dip_switch = dip_switch And %00011100
	MOVF 0x051,W
	MOVWF R0L
	MOVLW 0x1C
	ANDWF R0L,W
	MOVWF 0x051
; 144: dip_switch = dip_switch / 4
	MOVF 0x051,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x04
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R0L,W
	MOVWF 0x051
; 145: 'MIN = 2^0 X 100 = 100 MSec,  max = 2^7  x 100 = 12,8 sec.
; 146: calc_delay = Power(2, dip_switch)
	CLRF 0x042
	CLRF 0x043
	CLRF 0x044
	MOVLW 0x80
	MOVWF 0x045
	MOVF 0x051,W
	MOVWF 0x04A
	CALL _append_lab_0001
	MOVF 0x046,W
	MOVWF 0x052
	MOVF 0x047,W
	MOVWF 0x053
	MOVF 0x048,W
	MOVWF 0x054
	MOVF 0x049,W
	MOVWF 0x055
; 147: calc_delay = calc_delay * 100
	CLRF BARGB2
	CLRF BARGB1
	MOVLW 0x48
	MOVWF BARGB0
	MOVLW 0x85
	MOVWF BEXP
	MOVF 0x052,W
	MOVWF AARGB2
	MOVF 0x053,W
	MOVWF AARGB1
	MOVF 0x054,W
	MOVWF AARGB0
	MOVF 0x055,W
	MOVWF AEXP
	CALL FPM32
	MOVF AARGB2,W
	MOVWF 0x052
	MOVF AARGB1,W
	MOVWF 0x053
	MOVF AARGB0,W
	MOVWF 0x054
	MOVF AEXP,W
	MOVWF 0x055
; 148: turnout_delay = calc_delay  'convert to integer
	MOVF 0x052,W
	MOVWF AARGB2
	MOVF 0x053,W
	MOVWF AARGB1
	MOVF 0x054,W
	MOVWF AARGB0
	MOVF 0x055,W
	MOVWF AEXP
	CALL INT3224
	MOVF AARGB2,W
	MOVWF 0x056
	MOVF AARGB1,W
	MOVWF 0x057
; 149: Return
	RETURN
; End of user code
L0038:	GOTO L0038
; APPEND CODE BEGIN: _routine_single_power_
_append_lab_0001:
	CLRF 0x046
	CLRF 0x047
	CLRF 0x048
	MOVLW 0x7F
	MOVWF 0x049
L0039:
	MOVLW 0x01
	SUBWF 0x04A,W
	BTFSS STATUS,C
	GOTO L0040
	MOVF 0x042,W
	MOVWF BARGB2
	MOVF 0x043,W
	MOVWF BARGB1
	MOVF 0x044,W
	MOVWF BARGB0
	MOVF 0x045,W
	MOVWF BEXP
	MOVF 0x046,W
	MOVWF AARGB2
	MOVF 0x047,W
	MOVWF AARGB1
	MOVF 0x048,W
	MOVWF AARGB0
	MOVF 0x049,W
	MOVWF AEXP
	CALL FPM32
	MOVF AARGB2,W
	MOVWF 0x046
	MOVF AARGB1,W
	MOVWF 0x047
	MOVF AARGB0,W
	MOVWF 0x048
	MOVF AEXP,W
	MOVWF 0x049
	MOVLW 0x01
	SUBWF 0x04A,W
	MOVWF 0x04A
	GOTO L0039
L0040:
	RETURN
; APPEND CODE END.
;
;
; Delay Routine Byte
; minimal routine execution time: 2s
; routine execution time step: 1s
; maximal routine execution time: 256s
DL01:
	NOP
	NOP
	DECFSZ R4L,F
	GOTO DL01
	RETURN
; Delay Routine Word
; minimal routine execution time: 3s
; routine execution time step: 2s
; maximal routine execution time: 131073s
DL02:
	MOVLW 0x01
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO DL02
; Waitms Routine
W001:	MOVLW 0x01
	SUBWF R0L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R0H,F
	BTFSS STATUS,C
	RETURN
	MOVLW 0xF1
	MOVWF R4L
	MOVLW 0x01
	MOVWF R4H
	CALL DL02
	GOTO W001
;
;
; Word Division Routine
D001:	MOVLW 0x10
	MOVWF R3L
	CLRF R2H
	CLRF R2L
D002:	RLF R0H,W
	RLF R2L,F
	RLF R2H,F
	MOVF R1L,W
	SUBWF R2L,F
	MOVF R1H,W
	BTFSS STATUS,C
	INCFSZ R1H,W
	SUBWF R2H,F
	BTFSC STATUS,C
	GOTO D003
	MOVF R1L,W
	ADDWF R2L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R2H,F
	BCF STATUS,C
D003:	RLF R0L,F
	RLF R0H,F
	DECFSZ R3L,F
	GOTO D002
	RETURN
; I2CWrite Routine
IC01:	MOVWF R0L
	MOVLW 0x08
	MOVWF R0H
IC02:	RLF R0L,F
	BTFSC STATUS,C
	CALL IC20
	BTFSS STATUS,C
	CALL IC21
	CALL IC22
	CALL IC23
	DECFSZ R0H,F
	GOTO IC02
	CALL IC24
	CALL IC03
	CALL IC25
	CALL IC21
	RETURN
IC03:
	CALL IC22
	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	ANDWF INDF,W
	ADDLW 0xFF
	CALL IC23
	RETURN
IC31:
	CALL IC21
	CALL IC23
	GOTO IC29
IC41:
	CALL IC22
	CALL IC20
	GOTO IC29
IC20:	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	IORWF INDF,F
	GOTO IC28
IC21:	MOVF SDA_PORT,W
	MOVWF FSR
	COMF SDA_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC22:	MOVF SCL_PORT,W
	MOVWF FSR
	MOVF SCL_BIT,W
	IORWF INDF,F
	GOTO IC28
IC23:	MOVF SCL_PORT,W
	MOVWF FSR
	COMF SCL_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC28:	BSF FSR,7
	COMF INDF,W
	BCF FSR,7
	ANDWF INDF,F
IC29:
	NOP
	NOP
	NOP
	NOP
	NOP
	RETURN
IC24:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	MOVF SDA_BIT,W
	IORWF INDF,F
	RETURN
IC25:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	COMF SDA_BIT,W
	ANDWF INDF,F
	RETURN
;
;protected:J0^u{gws,hulnuvp%X|~x|i,Nqn/A
;protected:QX\2?A>RTZbOu!N81>GA
;protected:[SbbH>JTh[
;protected:PL]T,kLNY
;protected:ErGoX&NV\VP48B
;protected:eXc_+Z_M>@?J
;protected:JZYI>B]WMOG6U
;protected:G[XH>JPbRN>,Q
;protected:OgPM+MDpH^52S
;protected:S]QJ,LCpPQB7R
;protected:B_T_[#Z_MWsTH_
;protected:VcMU.EM]I`:;V
;protected:NaF^Q,kWH_aVJ[
;protected:NTP[*POVSM2JO
;protected:R^R-STUZD:
;protected:U]Y6P4N?Pa\U.XQXR`9
;protected:]ZbS LO^_E77c
;protected:`UbXY-h^PbY_7\
;protected:P^dZ,[O][?J69
;protected:YRtG<FG_\L@:[
;protected:XQt`U0LM_GM>
;protected:eR]Q,D_ScG89l
;protected:\]ZcQ"_JaWM=
;protected:CW`R8DH]SEP
;protected:^XL-iO\^F<75
;protected:V^fQ,NA]UNH/^
;protected:NWdTo%YaV^da0f
;protected:Im]^0Y[_M>@?J
;protected:TZbI>B]WMOF6f
;protected:Q[aYd)PQ]SO0
;protected:QXjI'LMUeCM
;protected:HP[*cSQ\M2J<
;protected:R^R-TP[\Z33?
;protected:PmWb%GNgQQ>0c
;protected:DrObS+_aA_c_D]
;protected:R[Wm!nJY=H<
;protected:]]VY>4Q;IX[cF+bQeSI;8Z
;protected:TqG]S5KTfT8Q
;protected:`]Uc^,`TLbak/a
;protected:NWdTo%YaV^da0O
;protected:Im]^0^QaF`\?J
;protected:INR#qU]Y[`AM
;protected:]]VY>4Q;PJ
;protected:NaF^Q,YDYRN3J8
;protected:LUad*UW\_TIl<A
;protected:]XS LO^_E97R
;protected:pMb%GNgQQ?0R
;protected:TjO/QL^TB;:R
;protected:GLNRVx!]J^]AP
;protected:US`Z"lXa]>>@2L
;protected:SgWV+_HrGqS9?
;protected:[V^A6?=<V^fWc-3<9=J:
;protected:X[YuG<FKee
;protected:RZVR+UgP]
;protected:M`SS^.MYUNM</U
;protected:cTZ\5Xa[8<>4
;protected:L^]Q,NA]UNK/M
;protected:ORkG<FG_\LA:J
;protected:NQkO/QL^TB<:R
;protected:FVXR#_BnLH=AP
;protected:WROQ"_JaWM?9F
;protected:P`^VJ+_W_UqX2g
;protected:S]QJ,LCpPQB7R
;protected:B_T_[#Z_MWsTH_
;protected:VcMU.EM]I`:;V
;protected:NaF^Q,kWH_aVJ[
;protected:NTP[*POVSM2JO
;protected:R^R-STUZD:
;protected:U]Y7N4N?Pa\U.XQXR`9
;protected:]ZbS LO^_E77c
;protected:`UbXY-h^PbY_7\
;protected:P^dZ,[O][@H69
;protected:YRtG<FG_\L@:[
;protected:XQt`U0LM_GM>
;protected:eR]Q,D_ScG89l
;protected:\]ZcQ"_JaWM=
;protected:MZdR8DH]SEQ-s
;protected:S\kaU.EM]I`;
;protected:SW^S LO^_E:
;protected:NVd!pJS]W:;A
;protected:YZXd)PQ]SO07e
;protected:ZWM^_#qU]Y[`Ad
;protected:US`Z"lXa]?<@2
;protected:[[nI'LMUeCM1]
;protected:bYeeJ,LCpPQ@
;protected:Y\VQ.MYUNM>/u
;protected:iT\d[*POVSM3
;protected:L[bQ,NA]UNJ
;protected:INR#rFiUH=A=
;protected:PWR+VcV_R;8A
;protected:X]b^#HL^J`1H\
;protected:OiPba$__Cr^b<e
;protected:TO_],fRYX@3Q3
;protected:RUc[*POVSM3J`
;protected:]ZbdF+OMjJI;
;protected:FjSb%GNgQQ?
;protected:N^H>]T][N=,>
;protected:YgYM+MDpH^52d
;protected:LcTWO+UrJce^8g
;protected:R]`g#YP_3Q3
;protected:jTXZI:B@>XQtO/dPY]B;:c
;protected:V\McI>Ba]V9[
;protected:QbJ_^"q]Pd`_9Z
;protected:P`^VZ+_W_UqX2P
;protected:Q^bS,^GrOd^>>
;protected:BNT,kWH_aVJD
;protected:jTXZI:B@EF
;protected:DrObS+MNRRP<D:
;protected:R[Wm!jWS_cNC>7>
;protected:TjO/QL^TB>:R
;protected:USQ,D_ScG89[
;protected:aZJ,LCpPQA7R
;protected:RWT,YDYRN3JG
;protected:IKP[]i.EQcRJO
;protected:WZ`\ Y]^e77>>D
;protected:HkYU-hOcTYZ>4
;protected:qNcV`Z@2ENkI'Q\IjBcX2?
;protected:LcTW_+HnO[QR_97
;protected:`QlO^+<{dG
;protected:RUcaa/>|<<
;protected:kXegQ,NEc^
;protected:[OYQ,D_ScG6
;protected:XVaT$MLTeK@
;protected:NX_F+OMjJI=
;protected:UjG<XOTc6U
;protected:V^Q"_JaWM<9F
;protected:`QlO^+<{dG
;protected:oJZSd`B@>MUd)U`QXNG^:=
;protected:E[Q_V>GlKRN\];E
;protected:^PVj`/@RS
;protected:X]bdZ';Id
;protected:iT\d[*PS\\
;protected:Om_fV+MNRRP<
;protected:PVacI>B]WMOF
;protected:\]ZcQ"_JaWM>
;protected:RWT,kLNY8I
;protected:SnK&NV\VP48Q
;protected:pNc\b,=xQT
;protected:_]WPZb6P3P?OhP/TTRWCe\;@
;protected:NaF^a,^SMWMJq-S
;protected:XRiVf.4QH
;protected:L[bQ,NA]UNH
;protected:I_RVq!oNM[AA
;protected:[SbWY>9VQ
;protected:ZOaeR8DH]SEN
;protected:iT\d[*POVSM3
;protected:V^fbR-AL`SZ5
;protected:]XI>TeLT9[
;protected:a`J,LCpPQ@7R
;protected:RPbXo#7RI
;protected:dJtXOTc=AHN_Hq\/cTS[,B
;protected:N[I'LMUeCL1=
;protected:gOcZ[,;zN9
;protected:aU^<@2EOdUM+MDpH^5
;protected:Pa\U.EM]I`:
;protected:SW^S LO^_E9
;protected:OOpG<FG_\LB
;protected:GX]H>JTh[
;protected:_E_Zc83;<
;protected:QpNnSJAE=AH
;protected:N_HqL/V[RYARa8N
;protected:I_RVq!]FXTW<;>
;protected:SZVm)UYc_VGYA>
;protected:E[Q_V>B]WMOH6F
;protected:K[_Q>OXh^UTN>@
;protected:aQJQ,D_ScG89[
;protected:QbJ_N"q]Pd`_9Z
;protected:WZ[I'LMUeCM1L
;protected:W^UaG,^V_]dc7f
;protected:IYQR8DH]SEN-b
;protected:Ha[]b.W`LVs\;j
;protected:S\TZ.Ra[ZTSQQ3
;protected:WXS5KP`KN;.d
;protected:abQ,NA]UNI/M
;protected:^Ud!]FXTW<;T
;protected:UYEd)PUc\9F
;protected:P`^VJ+_W_UqX2g
;protected:Q^bS,^GrO^f>>
;protected:GZb[8IPc_LeOO7
;protected:A-hs}upq+Rnry~u|n+`{wpyq#apj&?
;protected:^XcA6>?<V^fQ,NEc^8o
;protected:I_RVa!oYGaj];h
;protected:^PVj`/@<=
;protected:X]b^#HL^J`1H\
;protected:Zd`fT$_TIl
;protected:QcQ,NA]UNH/>
;protected:YRtMs%7?L5AA
;protected:_`DuO/QPd],Q
;protected:NlIZ^,DcYl1=
;protected:\Yc]$_PVgXeC=>A
;protected:N]Y^#HPdSJG
;protected:NTP[*PS\\7H
;protected:V^fWc-8
;protected:aaZZM+MHvQH\
;protected:OiPba$__Cr^b<N
;protected:TO_],lVOTRWQ3N9
;protected:Zd`fT$MPZn
;protected:a\Q,NA]UNJ/M
;protected:YRtG<FG_\L@:[
;protected:XQt`U0LM_GM@
;protected:eR]Q,D_ScG69l
;protected:\]ZcQ"_JaWM=
;protected:CW`R8DH]SEN
;protected:iT\Yl*G
;protected:WaMYd)PUc\9W
;protected:P`^VZ+_W_UqX2P
;protected:Q^bS,_UfRUd>>?4
;protected:[[nZM+MHvQ
;protected:WRS5KP`KN=.d
;protected:\_aR-AL`SZ43b
;protected:PmWsK&NV\VP6
;protected:NNpO/QL^TB<
;protected:YgYSb,;
;protected:TqG]S5KTfT8b
;protected:`]Uc^,`TLbak/J
;protected:SRrP<YYU^PcA6>?
;protected:kXegQ,NEc^
;protected:jOM+MDpH^72S
;protected:M[`J,LCpPQB
;protected:Y\VQ.M][W7c
;protected:`UbXY-h^PbY_7\
;protected:KRV+_aA_c_DF
;protected:R[Wm!oMOSi=A@8[V
;protected:VqQXV_??2?HeR]Q,DcYl1]
;protected:W^UaG,^V_]dc7f
;protected:GZb[8VOTRWQ3N9UX
;protected:hRXTX?=4RCRNR-S_O`mV3N
;protected:UpG<FG_\L?:J
;protected:]Td)PQ]SO17T
;protected:jUM+MDpH^72S
;protected:NTQJ_e"_Ng`7R
;protected:GZb[8VOTRWQ3N9
;protected:YU^PcA6>?QiC
;protected:R_R`C+T\^OHR_/T
;protected:^YL`h*POVSM4J9
;protected:WZ`\ T\`K59?[N
;protected:CpKY`5]cOXa^.a
;protected:V__[-IYb?J5;ZW
;protected:gO_K&NV\VP68Q
;protected:`]UcN,`TLbak/a
;protected:UQaG<FG_\L@:J
;protected:MVd\R0^`NT`a8r
;protected:PYOI>B]WMOE6U
;protected:F`QUa)PQ]SO07E
;protected:_R[Z,VcUeT\@G<C
;protected:WR`>4P=^[EOTQa_8VPRZ/U
;protected:nJZYl*?4<
;protected:EmVU0LM_GM>8^
;protected:JZYI>B]WMOF6U
;protected:G[XH>JPbRN?,Q
;protected:UfFM+MDpH^72S
;protected:LcTWO+UrJce^8g
;protected:T\O^#HL^J`2HK
;protected:OiPbQ$__Cr^b<e
;protected:VNNT,YDYRN3JG
;protected:WKaaa/>|<;
;protected:KpNb@>>?4EOdUM+MDpH^5
;protected:Pa\U.EM]I`:
;protected:SW^S LO^_E9
;protected:^HrMs%6E:
;protected:X\X?=5PCSW^S LO^_E:
;protected:YRtG<FKee6f
;protected:F`QUa)bdL`bS7h
;protected:jH[Wc#NyL5
;protected:Zd`U.EM]I`9;g
;protected:Y\VbT,kLNY
;protected:EqG<FG_\L?:;
;protected:XQtUf0<>D+>?
;protected:kXIbR#_FtU2S
;protected:LcTW_+Cca_<B
;protected:TO_],kH[T[YQ3
;protected:HUZ[*PS\\7H
;protected:R]SQ,NEc^8^
;protected:TZbOu!T
;protected:YbWaU.EQcRJ`
;protected:R_R`S+a`YW\^8F
;protected:HkYU-i]WWJ`>4Q;
;protected:]ZbdF+OQpS
;protected:]XI>B]WMOH6U
;protected:Q[aH>JPbRN?,b
;protected:YgY^Q,D_ScG9
;protected:bYeT$MLTeK@<b
;protected:ZOaeR8DH]SEP
;protected:iT\S5KP`KN;.u
;protected:\_acS LO^_E8
;protected:OOpG<FG_\L?
;protected:Q[aNu)G
;protected:^aOWQ.M][W7c
;protected:`UbXY-h^PbY_7E
;protected:P^dZ,aSSWRl69>>
;protected:kPr\L-VOg^
;protected:^WH>JPbRN@,Q
;protected:YgYM+MDpH^72d
;protected:W^d[R+C_[VR>
;protected:ZOaT,YDYRN4JX
;protected:RUclP/OE^RDP
;protected:R\]R-AL`SZ4
;protected:X[YjX<=
;protected:`jLfT$MPZn5f
;protected:M`SS^._lD[`_/a
;protected:cTZ\5^bVMR_5P<A
;protected:X[cWQ.M][W
;protected:^Od!]FXTW=;T
;protected:YZXd)PQ]SO27e
;protected:eR]bR#_BnLH@
;protected:M[`J,LCpPQB
;protected:Y\VWe,P
;protected:Z`NZd!]J^]Aa
;protected:PXR^U>\cQ_a`,N
;protected:SgWV+`VfJbY9?H<
;protected:[SbbH>JTh[
;protected:_LQ.MYUNM?/d
;protected:_QXS5KP`KN>
;protected:kXeV+MRX[:c
;protected:E[Q_V>TpFZbh6i
;protected:FOQ"q]Pd`_9C
;protected:U[lR'^TLdUO79?dU
;protected:caLUQVQ;BBEZOaT,YH_[8Z
;protected:CpKYP5]cOXa^.x
;protected:V__[-SSWRl69>>Ri
;protected:TdNLaH<B@>MEd)bdL`bS7Q
;protected:jUM+MDpH^52S
;protected:\aT$MLTeK@<Q
;protected:_RQ.MYUNM>/d
;protected:nWL-VKaUF?7H
;protected:MTSQ_g LSdh/M
;protected:SRrP<XNV[^B@7>
;protected:^JgOcC=??OVH
;protected:ZWM^O#dQbQGTh6E
;protected:F`QUq)PQ]SO37>
;protected:_R[Z,LlUO79?dU
;protected:PXR^U>\cQ_a`,N
;protected:SgWV+UQr4N88\`
;protected:X\GR+C_[VR>8S
;protected:MbRkF'^`DrVo1`
;protected:^XRT$MLTeKA<Q
;protected:OTQaO8V[L`Xq-v
;protected:O[XP/OE^RDO5U
;protected:M`SSN._lD[`_/x
;protected:eSIS5KP`KN;.d
;protected:QdQ_P LO^_E77C
;protected:ePpT&`Z^X]Z?=4R
;protected:R]d>>@2ZYFE[Q_V>TeLT9L
;protected:aSXXb"N?@
;protected:O\MQ.MYUNM</d
;protected:_TSS5KP`KN<.d
;protected:R_XR-AL`SZ53Q
;protected:FmNb%GNgQQA0R
;protected:KlLU0LM_GMA8^
;protected:I_RVa!oYGaj];h
;protected:UYEd)PQ]SO27T
;protected:ZWM^O#qU]Y[`Ad
;protected:WROQ"_JaWM=9F
;protected:P`^VJ+_W_UqX2g
;protected:S]QJ,LCpPQ@7R
;protected:RPbXo#7<3
;protected:gSaX6@GDQP^Q"_JaWM<
;protected:CW`R8DH]SEO
;protected:_QXS5KP`KN=
;protected:aUaV+MNRRP?
;protected:UL_XZ>156
;protected:`Z^X]Z?=<KbV+R]FWOSk/7
;protected:NWdTo%L][VPUW8B
;protected:pNc\b,=xQT
;protected:[OYQ,D_ScG6
;protected:W^UaW,^KeW;G
;protected:Y\VWe,H{MQ
;protected:PmWsK&NV\VP4
;protected:XQt`U0LM_GM?
;protected:eR]bR#_BnLH?
;protected:W^d[R+C_[VR>
;protected:_LQ._aJU7R
;protected:pSb%GNgQQ>0R
;protected:Tc][g+<FQ
;protected:I,klurxh>Qjivs~|$^zwr}u+Ylw||
;protected:M[Y6P;RUc[*PS\\7Y
;protected:KcV^_-S_O`mV3e
;protected:PmWb%HRmZ;e
;protected:N_HqL/c_MaU^:f
;protected:JV_[#pFo59?
;protected:b=APRQ;<V^fQ,NA]UNH/^
;protected:dRpXb%HNgQQ>0c
;protected:Om_fV+_VGY
;protected:YgYM+NHvQH\
;protected:NYNfT$MPZn5U
;protected:X[cLb.=J:4<
;protected:ErGoX&`iKccW8N
;protected:eXc_+YaUYA>
;protected:V\McI>Ba]V9[
;protected:QbJ_N"q]Pd`_9C
;protected:U[lR'^QWdPr88
;protected:\Yc]$YZMQ;
;protected:\d`Z@2E_mE^Q,DcYl1L
;protected:W^UaW,^V_]dc7O
;protected:GZb[8VL_RXl4N
;protected:RUXH<IQ[aH>JPbRN=,b
;protected:YgY^Q,D_ScG9
;protected:bYeT$MLTeK@<b
;protected:ZOaeR8DH]SER
;protected:iT\S5KP`KN=.u
;protected:\_acS LO^_E<
;protected:NVd!]FXTW=;E
;protected:N^H>KPbRN=,B
;protected:N[I'^`DrVo1I
;protected:XVaT$MLTeK?
;protected:NX_F+OMjJI<
;protected:FjSb%GNgQQ@
;protected:YZXj`/B?
;protected:ZOaeR8WLX\EN
;protected:NhTU]H<I
;protected:F`QUq)PQ]SO57>
;protected:_R[Z,PlP]IJ@G
;protected:WPRH?=<V^fQ,OA]UNJ/^
;protected:MGbXb%GNgQQ@0R
;protected:Om_U0MM_GM?8o
;protected:I_RVa!oYGaj];Q
;protected:UYEd\i0MM_GM?8o
;protected:HOPZd!]FXTW;;T
;protected:YZXd)QQ]SO07e
;protected:ZWM^O#qU]Y[`AM
;protected:WROQUx)QQ]SO07e
;protected:YGKbR#_BnLH=AP
;protected:\\SMOFQ;I]^S LO^_E77R
;protected:pSb%GNgQQ?0R
;protected:TpO/QL^TB=:R
;protected:UYQ,D_ScG99[
;protected:a`J,LCpPQD7R
;protected:R]T,YDYRN8JG
;protected:GIS5]cOXa^.a
;protected:SUNR`Z+bQeSI;8I
;protected:HkYU-bV^]T?=
;protected:`]UcN,NA]UNH/>
;protected:SRrP<RX\jXSA6
;protected:]Nd)PQ]SO37T
;protected:jOM+MDpH^72S
;protected:\[T$MLTeK@<Q
;protected:_LQ.MYUNM</d
;protected:`JIS5KTfT8Q
;protected:OpXd^O??:
;protected:P`^VJ+RSdM]LY9K
;protected:QbJ_^"_JaWM>90
;protected:U[lR'XaOQ3kP
;protected:OiPba$MLTeKB<B
;protected:TO_],eXS>>Ri
;protected:eSIS5KP`KN=.d
;protected:QdQ_P ^bMlXZ7f
;protected:gO_K&NV\VP58Q
;protected:`]UcN,`TLbak/a
;protected:UQaG<FG_\L?:J
;protected:MVd\b0^`NT`a8r
;protected:NZ`R>NqQ9?dU
;protected:`VR+C_[VR;8S
;protected:]`R8DH]SEO-b
;protected:X_[*POVSM4JO
;protected:YYOS LSdh/M
;protected:NWdT_%YaV^da0f
;protected:Im]^0^QaFZd?J
;protected:P\W?5mLVHa[]b.WURPJ@
;protected:RNR-AL`SZ33B
;protected:UcUh\&=:?
;
; Configuration settings
	ORG 0x2007
	DW 0x3F50
	DW 0x3EFF
; End of listing
	END
